/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.util.DataPortListenerInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DataPortListener {
    private static final String TRACE_MASKT = "XPADLIST";
    private static final String TRACE_MASKF = "XPADLISF";
    private static final String TRACE_MASKD = "XPADLISD";
    private ArrayList _dataEvent = new ArrayList(4);
    private ArrayList _listenerList = new ArrayList(4);
    private Object _requestLock = new Object();
    private static DataPortListener _myself = null;
    private static ArrayList _regCListeners = new ArrayList(2);

    private DataPortListener() {
        this.startThread();
    }

    private void startThread() {
        Thread myThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Trace.trace(DataPortListener.TRACE_MASKD, "request thread running");
                ArrayList clonedList = null;
                while (true) {
                    PortData element = null;
                    Object object = DataPortListener.this._requestLock;
                    synchronized (object) {
                        while (DataPortListener.this._dataEvent.isEmpty()) {
                            Trace.trace(DataPortListener.TRACE_MASKD, "list is empty");
                            try {
                                Trace.trace(DataPortListener.TRACE_MASKD, "wait");
                                DataPortListener.this._requestLock.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        Trace.trace(DataPortListener.TRACE_MASKD, "got something to do. get it.");
                        element = (PortData)DataPortListener.this._dataEvent.remove(0);
                        clonedList = (ArrayList)DataPortListener.this._listenerList.clone();
                    }
                    Iterator it = clonedList.iterator();
                    while (it.hasNext()) {
                        Trace.trace(DataPortListener.TRACE_MASKD, "calling listener" + it);
                        ((DataPortListenerInterface)it.next()).handle(element.command, element.data, element.dataLength);
                    }
                    clonedList = null;
                }
            }
        });
        myThread.setDaemon(true);
        myThread.setName("Data Port Listener Thread");
        myThread.start();
    }

    public static synchronized DataPortListener getDataPortListener() {
        if (_myself == null) {
            _myself = new DataPortListener();
        }
        return _myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postIt(int command, byte[] data, int dataLength) {
        Trace.trace(TRACE_MASKD, "post event to the list");
        PortData anElement = new PortData();
        anElement.command = command;
        anElement.data = data;
        anElement.dataLength = dataLength;
        Object object = this._requestLock;
        synchronized (object) {
            this._dataEvent.add(anElement);
            this._requestLock.notifyAll();
        }
    }

    public static void postData(int messageType, int command, byte[] data, int dataLength) {
        Trace.trace(TRACE_MASKD, "--> Handle get data event");
        Trace.trace(TRACE_MASKD, "messageType = " + messageType);
        if (messageType == 1) {
            Trace.trace(TRACE_MASKD, "got a register message");
            String dataString = new String(data);
            StringTokenizer st = new StringTokenizer(dataString, ";;");
            RegisteredCListener regCElement = new RegisteredCListener();
            try {
                regCElement.sharedObject = st.nextToken();
                regCElement.entryPoint = st.nextToken();
                Trace.trace(TRACE_MASKD, "adding so   = " + regCElement.sharedObject);
                Trace.trace(TRACE_MASKD, "entry point = " + regCElement.entryPoint);
                _regCListeners.add(regCElement);
            }
            catch (Exception e) {}
        } else {
            DataPortListener dataPortListener = DataPortListener.getDataPortListener();
            dataPortListener.postIt(command, data, dataLength);
        }
        Trace.trace(TRACE_MASKD, "<-- Handle data event");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DataPortListenerInterface listener) {
        Trace.trace(TRACE_MASKF, "<--> adding listener " + listener);
        Object object = this._requestLock;
        synchronized (object) {
            if (this._listenerList.contains(listener)) {
                Trace.trace(TRACE_MASKF, listener + " is already in the list don't add");
            } else {
                Trace.trace(TRACE_MASKF, "added " + listener);
                this._listenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DataPortListenerInterface listener) {
        Trace.trace(TRACE_MASKF, "<--> removing data listener " + listener);
        Object object = this._requestLock;
        synchronized (object) {
            this._listenerList.remove(listener);
        }
    }

    private static int sendDataMessage(int messageType, int command, byte[] data, String target, int targetCount) throws HException {
        Object result = null;
        Trace.trace(TRACE_MASKT, "--> sendDataMessage");
        try {
            NativeBridge bridge = new NativeBridge();
            NativeProcessParameters nativeProcessParameter = new NativeProcessParameters("actzNativeBridgeMain");
            bridge.exec(nativeProcessParameter);
            Object[] args = new Object[]{new Integer(messageType), new Integer(command), data, target.getBytes(), new Integer(targetCount)};
            result = bridge.invokeNativeFunction("libiqypdata", "java_xp_data_receive", args);
            Trace.trace(TRACE_MASKD, "ended with result = " + result);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got exception");
            Trace.trace(TRACE_MASKD, e);
            throw new HException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- sendDataMessage");
        if (result instanceof Integer) {
            return (Integer)result;
        }
        return 0;
    }

    public static int sendData(int command, byte[] data) throws HException {
        int length = _regCListeners.size();
        Iterator crlIt = _regCListeners.iterator();
        StringBuffer sb = new StringBuffer();
        while (crlIt.hasNext()) {
            RegisteredCListener element = (RegisteredCListener)crlIt.next();
            sb.append(element.sharedObject.concat(";").concat(element.sharedObject).concat(";"));
        }
        Trace.trace(TRACE_MASKD, "sb = " + sb);
        return DataPortListener.sendDataMessage(1, command, data, sb.toString(), length);
    }

    public static int sendData(int command, byte[] data, String sharedObject, String entryPoint) throws HException {
        Trace.trace(TRACE_MASKD, "--> sendData");
        String target = sharedObject + ";" + entryPoint + ";";
        Trace.trace(TRACE_MASKD, "target is " + target);
        return DataPortListener.sendDataMessage(1, command, data, target, 1);
    }

    public static int sendData(int command, byte[] data, String[] sharedObjects, String[] entryPoints) throws HException {
        Trace.trace(TRACE_MASKD, "--> sendData mulitple targets");
        StringBuffer targets = new StringBuffer();
        Trace.trace(TRACE_MASKD, "got " + sharedObjects.length + " targets to process");
        int i = 0;
        while (i < sharedObjects.length) {
            Trace.trace(TRACE_MASKD, "i=" + i);
            Trace.trace(TRACE_MASKD, "sharedObjects=" + sharedObjects[i]);
            Trace.trace(TRACE_MASKD, "entry point=" + entryPoints[i]);
            targets.append(sharedObjects[i]).append(";").append(entryPoints[i]).append(";");
            ++i;
        }
        Trace.trace(TRACE_MASKD, "targets are " + targets);
        return DataPortListener.sendDataMessage(1, command, data, targets.toString(), sharedObjects.length);
    }

    public static void main(String[] args) {
        try {
            Trace.trace(TRACE_MASKD, "send out the data");
            DataPortListener dp = new DataPortListener();
            String message = "This is a test message";
            String[] libs = new String[]{"libiqypdata.so", "libiqypdata.so", "libiqypdata.so"};
            String[] entries = new String[]{"xp_data_test1", "xp_data_test2", "xp_data_test3"};
            int rc = DataPortListener.sendData(1, message.getBytes(), libs, entries);
            Trace.trace(TRACE_MASKD, "got rc = " + rc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "exception");
            Trace.trace(TRACE_MASKD, e);
            System.out.println(e);
        }
    }

    static class RegisteredCListener {
        public String sharedObject;
        public String entryPoint;

        RegisteredCListener() {
        }
    }

    static class PortData {
        public int command;
        public byte[] data;
        public int dataLength;

        PortData() {
        }
    }
}

